/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_kits;

import dev.sepd.sepd_kits.KitGUI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Sepd_Kits
extends JavaPlugin
implements CommandExecutor,
Listener {
    public static Sepd_Kits instance;
    final Map<String, Kit> kits = new HashMap<String, Kit>();
    private File kitsFolder;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.kitsFolder = new File(this.getDataFolder(), "kits");
        if (!this.kitsFolder.exists()) {
            this.kitsFolder.mkdirs();
        }
        this.loadKits();
        for (String cmd : Arrays.asList("kit", "createkit", "editkit", "deletekit", "claimkit", "givekit", "reloadkits", "renamekit", "helpkit")) {
            PluginCommand pluginCommand = this.getCommand(cmd);
            if (pluginCommand == null) continue;
            pluginCommand.setExecutor((CommandExecutor)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new KitGUI(), (Plugin)this);
        this.getLogger().info("Sepd_Kits loaded!");
    }

    private void loadKits() {
        this.kits.clear();
        File[] files = this.kitsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
            String name2 = file.getName().replace(".yml", "").toLowerCase();
            List contents = data.getList("items.contents", new ArrayList());
            List armor = data.getList("items.armor", new ArrayList());
            ItemStack offhand = data.getItemStack("items.offhand");
            boolean autoArmor = data.getBoolean("auto_armor", true);
            boolean autoOffhand = data.getBoolean("auto_offhand", true);
            boolean permissionRequired = data.getBoolean("permission_required", false);
            boolean clearBeforeGiving = data.getBoolean("clear_inventory_before_giving", false);
            int cooldown = data.getInt("cooldown", 0);
            HashMap<UUID, Long> cooldowns = new HashMap<UUID, Long>();
            if (data.contains("cooldowns")) {
                for (String uuid : data.getConfigurationSection("cooldowns").getKeys(false)) {
                    cooldowns.put(UUID.fromString(uuid), data.getLong("cooldowns." + uuid));
                }
            }
            this.kits.put(name2, new Kit(name2, contents, armor, offhand, autoArmor, autoOffhand, permissionRequired, cooldown, cooldowns, clearBeforeGiving));
        }
    }

    private void saveKit(Kit kit) {
        File file = new File(this.kitsFolder, kit.name + ".yml");
        YamlConfiguration data = new YamlConfiguration();
        data.set("auto_armor", (Object)kit.autoArmor);
        data.set("auto_offhand", (Object)kit.autoOffhand);
        data.set("permission_required", (Object)kit.permissionRequired);
        data.set("clear_inventory_before_giving", (Object)kit.clearBeforeGiving);
        data.set("cooldown", (Object)kit.cooldown);
        data.set("items.contents", kit.contents);
        data.set("items.armor", kit.armor);
        data.set("items.offhand", (Object)kit.offhand);
        for (Map.Entry<UUID, Long> entry : kit.cooldowns.entrySet()) {
            data.set("cooldowns." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
        try {
            data.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteKitFile(String name) {
        File file = new File(this.kitsFolder, name + ".yml");
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String name = cmd.getName().toLowerCase();
        if (name.equals("kit")) {
            if (sender instanceof Player) {
                KitGUI.openKitMenu((Player)sender, 0);
            } else {
                sender.sendMessage("Only players can use this command.");
            }
            return true;
        }
        if (name.equals("helpkit")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.help-header")));
            for (String line : this.getConfig().getStringList("messages.help-lines")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            return true;
        }
        if (name.equals("createkit") && sender instanceof Player) {
            if (args.length != 1) {
                return this.usage(sender, "/createkit <name>");
            }
            String kitName = args[0].toLowerCase();
            if (this.kits.containsKey(kitName)) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-exists"), "%kitname%", kitName));
            }
            Player player = (Player)sender;
            ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
            for (ItemStack item : player.getInventory().getStorageContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                contents.add(item.clone());
            }
            List<ItemStack> armor = this.filterItems(player.getInventory().getArmorContents());
            ItemStack offhand = player.getInventory().getItemInOffHand();
            Kit kit = new Kit(kitName, contents, armor, offhand.clone(), true, true, false, 0, new HashMap<UUID, Long>(), false);
            this.kits.put(kitName, kit);
            this.saveKit(kit);
            return this.success(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-created"), "%kitname%", kitName));
        }
        if (name.equals("editkit") && sender instanceof Player) {
            if (args.length != 1) {
                return this.usage(sender, "/editkit <name>");
            }
            String kitName = args[0].toLowerCase();
            Kit kit = this.kits.get(kitName);
            if (kit == null) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-not-found"), "%kitname%", kitName));
            }
            Player player = (Player)sender;
            ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
            for (ItemStack item : player.getInventory().getStorageContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                contents.add(item.clone());
            }
            List<ItemStack> armor = this.filterItems(player.getInventory().getArmorContents());
            ItemStack offhand = player.getInventory().getItemInOffHand();
            kit.contents = contents;
            kit.armor = armor;
            kit.offhand = offhand.clone();
            this.saveKit(kit);
            return this.success(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-updated"), "%kitname%", kitName));
        }
        if (name.equals("deletekit")) {
            if (args.length != 1) {
                return this.usage(sender, "/deletekit <name>");
            }
            String kitName = args[0].toLowerCase();
            if (!this.kits.containsKey(kitName)) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-not-found"), "%kitname%", kitName));
            }
            this.kits.remove(kitName);
            this.deleteKitFile(kitName);
            return this.success(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-deleted"), "%kitname%", kitName));
        }
        if (name.equals("claimkit") && sender instanceof Player) {
            long lastUsed;
            long elapsed;
            if (args.length != 1) {
                return this.usage(sender, "/claimkit <name>");
            }
            Player player = (Player)sender;
            String kitName = args[0].toLowerCase();
            Kit kit = this.kits.get(kitName);
            if (kit == null) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-not-found"), "%kitname%", kitName));
            }
            if (kit.permissionRequired && !player.hasPermission("sepd_kits.kits." + kitName)) {
                return this.error(sender, this.getConfig().getString("messages.no-permission"));
            }
            long now = System.currentTimeMillis();
            if (kit.cooldown > 0 && kit.cooldowns.containsKey(player.getUniqueId()) && (elapsed = (now - (lastUsed = kit.cooldowns.get(player.getUniqueId()).longValue())) / 1000L) < (long)kit.cooldown) {
                long remaining = (long)kit.cooldown - elapsed;
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-cooldown"), "%seconds%", String.valueOf(remaining), "%kitname%", kitName));
            }
            if (!kit.clearBeforeGiving && !this.hasEnoughSpace(player, kit)) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.not-enough-space"), "%kitname%", kitName));
            }
            if (kit.clearBeforeGiving) {
                player.getInventory().clear();
            }
            kit.cooldowns.put(player.getUniqueId(), now);
            this.saveKit(kit);
            this.giveKit(player, kit);
            return true;
        }
        if (name.equals("givekit")) {
            if (args.length != 2) {
                return this.usage(sender, "/givekit <player> <kit>");
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            Kit kit = this.kits.get(args[1].toLowerCase());
            if (target == null || kit == null) {
                return this.error(sender, this.getConfig().getString("messages.invalid-player-or-kit"));
            }
            if (!kit.clearBeforeGiving && !this.hasEnoughSpace(target, kit)) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.not-enough-space"), "%kitname%", kit.name));
            }
            if (kit.clearBeforeGiving) {
                target.getInventory().clear();
            }
            this.giveKit(target, kit);
            return this.success(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-given"), "%player%", target.getName(), "%kitname%", kit.name));
        }
        if (name.equals("reloadkits")) {
            this.reloadConfig();
            this.loadKits();
            return this.success(sender, this.getConfig().getString("messages.kits-reloaded"));
        }
        if (name.equals("renamekit")) {
            if (args.length != 2) {
                return this.usage(sender, "/renamekit <old> <new>");
            }
            String oldName = args[0].toLowerCase();
            String newName = args[1].toLowerCase();
            Kit kit = this.kits.remove(oldName);
            if (kit == null) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-not-found"), "%kitname%", oldName));
            }
            if (this.kits.containsKey(newName)) {
                return this.error(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-exists"), "%kitname%", newName));
            }
            this.deleteKitFile(oldName);
            kit.name = newName;
            this.kits.put(newName, kit);
            this.saveKit(kit);
            return this.success(sender, this.replacePlaceholders(this.getConfig().getString("messages.kit-renamed"), "%oldname%", oldName, "%newname%", newName));
        }
        return false;
    }

    private List<ItemStack> filterItems(ItemStack[] items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            list.add(item.clone());
        }
        return list;
    }

    boolean hasEnoughSpace(Player player, Kit kit) {
        int freeSlots = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++freeSlots;
        }
        int needed = kit.contents.size() + (!kit.autoArmor ? kit.armor.size() : 0) + (!kit.autoOffhand && kit.offhand != null ? 1 : 0);
        return freeSlots >= needed;
    }

    void giveKit(Player player, Kit kit) {
        if (!kit.clearBeforeGiving && !this.hasEnoughSpace(player, kit)) {
            player.sendMessage(this.replacePlaceholders(this.getConfig().getString("messages.not-enough-space"), "%kitname%", kit.name));
            return;
        }
        if (kit.clearBeforeGiving) {
            player.getInventory().clear();
            player.getInventory().setArmorContents(null);
            player.getInventory().setItemInOffHand(null);
        }
        if (kit.autoArmor) {
            player.getInventory().setArmorContents(kit.armor.toArray(new ItemStack[0]));
        } else {
            for (ItemStack item : kit.armor) {
                if (item == null || item.getType() == Material.AIR) continue;
                player.getInventory().addItem(new ItemStack[]{item.clone()});
            }
        }
        for (ItemStack item : kit.contents) {
            if (item == null || item.getType() == Material.AIR) continue;
            player.getInventory().addItem(new ItemStack[]{item.clone()});
        }
        if (kit.offhand != null && kit.offhand.getType() != Material.AIR) {
            if (kit.autoOffhand) {
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> player.getInventory().setItemInOffHand(kit.offhand.clone()), 2L);
            } else {
                player.getInventory().addItem(new ItemStack[]{kit.offhand.clone()});
            }
        }
        player.sendMessage(this.replacePlaceholders(this.getConfig().getString("messages.kit-claimed"), "%kitname%", kit.name));
    }

    String replacePlaceholders(String message, String ... placeholders) {
        if (message == null) {
            return "";
        }
        String result = message;
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            result = result.replace(placeholders[i], placeholders[i + 1]);
        }
        Object prefixedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)result);
        if (!((String)prefixedMessage).startsWith(this.getPrefix())) {
            prefixedMessage = this.getPrefix() + (String)prefixedMessage;
        }
        return prefixedMessage;
    }

    private String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix", "&7[&bSepd&fKits&7] "));
    }

    private boolean success(CommandSender sender, String msg) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        return true;
    }

    private boolean error(CommandSender sender, String msg) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        return true;
    }

    private boolean usage(CommandSender sender, String usage) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getPrefix() + String.valueOf(ChatColor.YELLOW) + "Usage: " + usage)));
        return true;
    }

    public static class Kit {
        public String name;
        public List<ItemStack> contents;
        public List<ItemStack> armor;
        public ItemStack offhand;
        public boolean autoArmor;
        public boolean autoOffhand;
        public boolean permissionRequired;
        public int cooldown;
        public Map<UUID, Long> cooldowns;
        public boolean clearBeforeGiving;

        public Kit(String name, List<ItemStack> contents, List<ItemStack> armor, ItemStack offhand, boolean autoArmor, boolean autoOffhand, boolean permissionRequired, int cooldown, Map<UUID, Long> cooldowns, boolean clearBeforeGiving) {
            this.name = name;
            this.contents = contents;
            this.armor = armor;
            this.offhand = offhand;
            this.autoArmor = autoArmor;
            this.autoOffhand = autoOffhand;
            this.permissionRequired = permissionRequired;
            this.cooldown = cooldown;
            this.cooldowns = cooldowns;
            this.clearBeforeGiving = clearBeforeGiving;
        }
    }
}

