/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_kits;

import dev.sepd.sepd_kits.Sepd_Kits;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitGUI
implements Listener {
    private static final int GUI_SIZE = 27;
    private static final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();

    public static void openKitMenu(Player player, int page) {
        FileConfiguration config = Sepd_Kits.instance.getConfig();
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("gui.title", "&2Select a Kit"));
        ArrayList<String> kitNames = new ArrayList<String>(Sepd_Kits.instance.kits.keySet());
        int totalPages = (int)Math.ceil((double)kitNames.size() / 18.0);
        page = Math.max(0, Math.min(page, totalPages - 1));
        playerPages.put(player.getUniqueId(), page);
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)title);
        Material decoMat = Material.valueOf((String)config.getString("gui.decorative.material", "BLACK_STAINED_GLASS_PANE"));
        String decoName = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("gui.decorative.name", " "));
        ItemStack deco = KitGUI.createItem(decoMat, decoName);
        for (int i = 19; i <= 25; ++i) {
            gui.setItem(i, deco);
        }
        if (page > 0) {
            gui.setItem(18, KitGUI.getConfiguredItem("gui.items.previous-page", Map.of()));
        }
        if (page < totalPages - 1) {
            gui.setItem(26, KitGUI.getConfiguredItem("gui.items.next-page", Map.of()));
        }
        gui.setItem(22, KitGUI.getConfiguredItem("gui.items.page-indicator", Map.of("%page%", String.valueOf(page + 1))));
        int start = page * 18;
        int end = Math.min(start + 18, kitNames.size());
        for (int i = start; i < end; ++i) {
            String kitName = (String)kitNames.get(i);
            Sepd_Kits.Kit kit = Sepd_Kits.instance.kits.get(kitName);
            if (kit == null) continue;
            boolean hasPermission = !kit.permissionRequired || player.hasPermission("sepd_kits.kits." + kitName);
            long cooldownLeft = KitGUI.getCooldownLeft(player, kitName);
            boolean onCooldown = cooldownLeft > 0L;
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("%kitname%", kitName);
            replacements.put("%seconds%", String.valueOf(cooldownLeft));
            ItemStack displayItem = !hasPermission ? KitGUI.getConfiguredItem("gui.items.no-permission", replacements) : (onCooldown ? KitGUI.getConfiguredItem("gui.items.cooldown", replacements) : KitGUI.getConfiguredItem("gui.items.kit-item", replacements));
            gui.setItem(i - start, displayItem);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        FileConfiguration config = Sepd_Kits.instance.getConfig();
        if (e.getView().getTitle().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("gui.title")))) {
            e.setCancelled(true);
            HumanEntity clicker = e.getWhoClicked();
            if (!(clicker instanceof Player)) {
                return;
            }
            Player player = (Player)clicker;
            ItemStack clicked = e.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta() || clicked.getType() == Material.AIR) {
                return;
            }
            int slot = e.getRawSlot();
            if (slot == 18) {
                KitGUI.openKitMenu(player, KitGUI.getCurrentPage(player) - 1);
                return;
            }
            if (slot == 26) {
                KitGUI.openKitMenu(player, KitGUI.getCurrentPage(player) + 1);
                return;
            }
            String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
            Sepd_Kits.Kit kit = Sepd_Kits.instance.kits.get(name.toLowerCase());
            if (kit == null) {
                return;
            }
            if (kit.permissionRequired && !player.hasPermission("sepd_kits.kits." + name.toLowerCase())) {
                player.sendMessage(Sepd_Kits.instance.replacePlaceholders(config.getString("messages.no-permission"), "%kitname%", name));
                return;
            }
            long cooldownLeft = KitGUI.getCooldownLeft(player, name.toLowerCase());
            if (cooldownLeft > 0L) {
                player.sendMessage(Sepd_Kits.instance.replacePlaceholders(config.getString("messages.on-cooldown"), "%seconds%", String.valueOf(cooldownLeft), "%kitname%", name));
                return;
            }
            if (!kit.clearBeforeGiving && !Sepd_Kits.instance.hasEnoughSpace(player, kit)) {
                player.sendMessage(Sepd_Kits.instance.replacePlaceholders(config.getString("messages.not-enough-space"), "%kitname%", name));
                return;
            }
            Sepd_Kits.instance.giveKit(player, kit);
            KitGUI.setCooldown(player, name.toLowerCase(), kit.cooldown);
            player.closeInventory();
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        FileConfiguration config = Sepd_Kits.instance.getConfig();
        if (e.getView().getTitle().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("gui.title")))) {
            e.setCancelled(true);
        }
    }

    private static int getCurrentPage(Player player) {
        return playerPages.getOrDefault(player.getUniqueId(), 0);
    }

    private static ItemStack createItem(Material mat, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack createItem(Material mat, String name) {
        return KitGUI.createItem(mat, name, null);
    }

    private static ItemStack getConfiguredItem(String path, Map<String, String> replacements) {
        FileConfiguration config = Sepd_Kits.instance.getConfig();
        Material material = Material.matchMaterial((String)config.getString(path + ".material", "STONE"));
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(path + ".name", "Item"));
        List lore = config.getStringList(path + ".lore");
        if (material == null) {
            material = Material.STONE;
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            name = name.replace(entry.getKey(), entry.getValue());
        }
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                line = line.replace(entry.getKey(), entry.getValue());
            }
            finalLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        return KitGUI.createItem(material, name, finalLore.isEmpty() ? null : finalLore);
    }

    private static long getCooldownLeft(Player player, String kitName) {
        File file = new File(Sepd_Kits.instance.getDataFolder(), "kits/" + kitName + ".yml");
        if (!file.exists()) {
            return 0L;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        long lastUsed = config.getLong("cooldowns." + String.valueOf(player.getUniqueId()), 0L);
        int cooldown = config.getInt("cooldown", 0);
        long secondsPassed = (System.currentTimeMillis() - lastUsed) / 1000L;
        return Math.max(0L, (long)cooldown - secondsPassed);
    }

    private static void setCooldown(Player player, String kitName, int cooldown) {
        File file = new File(Sepd_Kits.instance.getDataFolder(), "kits/" + kitName + ".yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("cooldowns." + String.valueOf(player.getUniqueId()), (Object)System.currentTimeMillis());
        try {
            config.save(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

