/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_donutspawn;

import dev.sepd.sepd_donutspawn.PluginConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public final class Sepd_DonutSpawn
extends JavaPlugin
implements Listener {
    private PluginConfig pluginConfig;
    private Location spawnLocation;
    private final Map<UUID, Integer> teleportTasks = new HashMap<UUID, Integer>();
    private final Map<UUID, Location> teleportLocations = new HashMap<UUID, Location>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.pluginConfig = new PluginConfig(this.getConfig());
        this.spawnLocation = this.pluginConfig.getSpawnLocation();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Sepd_DonutSpawn enabled!");
    }

    public void onDisable() {
        this.teleportTasks.values().forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0));
        this.getLogger().info("Sepd_DonutSpawn disabled.");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.pluginConfig.getMessage("only-player"));
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "setspawn": {
                if (!player.hasPermission("donutspawn.setspawn")) {
                    player.sendMessage(this.pluginConfig.getMessage("no-permission"));
                    return true;
                }
                this.pluginConfig.setSpawnLocation(player.getLocation());
                this.spawnLocation = player.getLocation();
                this.saveConfig();
                player.sendMessage(this.pluginConfig.getMessage("set-spawn-success"));
                return true;
            }
            case "spawn": {
                if (!player.hasPermission("donutspawn.spawn")) {
                    player.sendMessage(this.pluginConfig.getMessage("no-permission"));
                    return true;
                }
                this.handleSpawn(player);
                return true;
            }
            case "reloadspawn": {
                if (!player.hasPermission("donutspawn.reload")) {
                    player.sendMessage(this.pluginConfig.getMessage("no-permission"));
                    return true;
                }
                this.reloadConfig();
                this.pluginConfig = new PluginConfig(this.getConfig());
                this.spawnLocation = this.pluginConfig.getSpawnLocation();
                player.sendMessage(this.pluginConfig.getMessage("reload-config-success"));
                return true;
            }
        }
        return false;
    }

    private void handleSpawn(Player player) {
        if (this.spawnLocation == null) {
            player.sendMessage(this.pluginConfig.getMessage("spawn-location-not-set"));
            return;
        }
        if (this.teleportTasks.containsKey(player.getUniqueId())) {
            return;
        }
        int delay = this.pluginConfig.getTeleportDelay();
        Location initialLocation = player.getLocation();
        UUID playerId = player.getUniqueId();
        this.teleportLocations.put(playerId, initialLocation);
        for (int i = 0; i <= delay; ++i) {
            int countdown = delay - i;
            int taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                if (!this.teleportTasks.containsKey(playerId)) {
                    return;
                }
                if (countdown > 0) {
                    player.sendMessage(this.pluginConfig.getMessage("teleport-countdown").replace("%countdown%", String.valueOf(countdown)));
                } else {
                    this.teleportTasks.remove(playerId);
                    this.teleportLocations.remove(playerId);
                    player.teleportAsync(this.spawnLocation).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.pluginConfig.getMessage("teleport-success"));
                        }
                    });
                }
            }, (long)i * 20L);
            this.teleportTasks.put(playerId, taskId);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.teleportTasks.containsKey(playerId)) {
            return;
        }
        Location from = this.teleportLocations.get(playerId);
        Location to = event.getTo();
        if (from == null || to == null || !from.getWorld().equals((Object)to.getWorld()) || from.distanceSquared(to) > 0.25) {
            Bukkit.getScheduler().cancelTask(this.teleportTasks.get(playerId).intValue());
            this.teleportTasks.remove(playerId);
            this.teleportLocations.remove(playerId);
            player.sendMessage(this.pluginConfig.getMessage("teleport-cancelled"));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (player.getBedSpawnLocation() == null && this.spawnLocation != null) {
            event.setDeathMessage(null);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (player.isOnline()) {
                    player.teleportAsync(this.spawnLocation).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.pluginConfig.getMessage("teleport-direct"));
                        }
                    });
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player.getBedSpawnLocation() == null && this.spawnLocation != null) {
            event.setRespawnLocation(this.spawnLocation);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (player.isOnline()) {
                    player.teleportAsync(this.spawnLocation).thenAccept(success -> {
                        if (success.booleanValue()) {
                            player.sendMessage(this.pluginConfig.getMessage("teleport-direct"));
                        }
                    });
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore() && this.spawnLocation != null) {
            player.teleportAsync(this.spawnLocation).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.pluginConfig.getMessage("teleport-direct"));
                }
            });
        }
    }
}

