/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_donutspawn;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class PluginConfig {
    private final FileConfiguration config;

    public PluginConfig(FileConfiguration config) {
        this.config = config;
    }

    public Location getSpawnLocation() {
        if (!this.config.contains("spawn.world")) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.config.getString("spawn.world"));
        if (world == null) {
            return null;
        }
        double x = this.config.getDouble("spawn.x");
        double y = this.config.getDouble("spawn.y");
        double z = this.config.getDouble("spawn.z");
        float yaw = (float)this.config.getDouble("spawn.yaw");
        float pitch = (float)this.config.getDouble("spawn.pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    public void setSpawnLocation(Location location) {
        this.config.set("spawn.world", (Object)location.getWorld().getName());
        this.config.set("spawn.x", (Object)location.getX());
        this.config.set("spawn.y", (Object)location.getY());
        this.config.set("spawn.z", (Object)location.getZ());
        this.config.set("spawn.yaw", (Object)Float.valueOf(location.getYaw()));
        this.config.set("spawn.pitch", (Object)Float.valueOf(location.getPitch()));
    }

    public int getTeleportDelay() {
        return this.config.getInt("teleport-delay", 5);
    }

    public String getMessage(String key) {
        return this.config.getString("messages." + key, "").replace("&", "\u00a7");
    }
}

