/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.sepd_donutspawn;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationTypeAdapter
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    public JsonElement serialize(Location location, Type type, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("world", location.getWorld().getName());
        obj.addProperty("x", (Number)location.getX());
        obj.addProperty("y", (Number)location.getY());
        obj.addProperty("z", (Number)location.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
        return obj;
    }

    public Location deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = element.getAsJsonObject();
        World world = Bukkit.getWorld((String)obj.get("world").getAsString());
        if (world == null) {
            return null;
        }
        return new Location(world, obj.get("x").getAsDouble(), obj.get("y").getAsDouble(), obj.get("z").getAsDouble(), obj.get("yaw").getAsFloat(), obj.get("pitch").getAsFloat());
    }
}

