/*
 * Decompiled with CFR 0.152.
 */
package dev.sepd.clickcmd;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClickCMD
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private FileConfiguration config;
    private long lastClickTime = 0L;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractEntityEvent event) {
        long remaining;
        long now = System.currentTimeMillis();
        if (now - this.lastClickTime < 100L) {
            return;
        }
        this.lastClickTime = now;
        Player clicker = event.getPlayer();
        Entity clicked = event.getRightClicked();
        if (!(clicked instanceof Player) || this.isNPC((Player)clicked)) {
            return;
        }
        Player target = (Player)clicked;
        String allowedWorlds = this.config.getString("allowed_worlds", "");
        if (!allowedWorlds.isEmpty() && !allowedWorlds.contains(clicker.getWorld().getName())) {
            return;
        }
        int cooldown = this.config.getInt("cooldown", 0);
        if (cooldown > 0 && this.cooldowns.containsKey(clicker.getUniqueId()) && (remaining = (this.cooldowns.get(clicker.getUniqueId()) - now) / 1000L) > 0L) {
            clicker.sendMessage(this.config.getString("cooldown_message", "&cPlease wait %time% seconds!").replace("%time%", String.valueOf(remaining)).replace("&", "\u00a7"));
            return;
        }
        String cmd = this.config.getString("command", "").replace("%player%", target.getName()).replace("%clicker%", clicker.getName());
        Bukkit.dispatchCommand((CommandSender)clicker, (String)cmd);
        if (cooldown > 0) {
            this.cooldowns.put(clicker.getUniqueId(), now + (long)cooldown * 1000L);
        }
    }

    private boolean isNPC(Player player) {
        return player.hasMetadata("NPC") || player.getName().contains("[NPC]") || player.getCustomName() != null && player.getCustomName().contains("NPC");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("clickcmdreload")) {
            if (!sender.hasPermission("clickcmd.reload")) {
                return true;
            }
            this.reloadConfig();
            this.config = this.getConfig();
            sender.sendMessage(this.config.getString("reload_message", "&aConfig reloaded!").replace("&", "\u00a7"));
            return true;
        }
        return false;
    }
}

